TCJ #42

                            The Z-System Corner

                                  Jay Sage


     A number of newer TCJ readers have commented that with this column they
feel that they are coming into the middle of a very involved discussion that
is hard to catch on to.  Of course, one answer to that problem is for new
TCJ readers to purchase back issues.  I have been writing this column
regularly since issue #25, and I am quite sure that all those back issues
are still available.  That solution notwithstanding, it is probably not a
bad idea to stand back every so often and try to comprehend a larger
picture.  That is one of the tasks I will undertake this time.

     Detailed technical content will not be forsaken entirely, however,
since I regard that as the primary purpose of my column.  At this point, I
suspect that I am too much of a Z-System expert to talk about very many
topics at a level that is appropriate for beginners.  To serve their needs,
I have been very actively soliciting articles from other authors.  In this
issue, for example, we have the first of the columns I promised a couple of
issues back on how to set up a remote access system (aka bulletin board
system) under the NZCOM auto-install version of Z-System.  Lee McEwen (aka
Chris McEwen) has done a lovely job with that assignment.

     The technical discussion this time will focus on some issues that arose
in trying to install ZSDOS or ZDDOS on an SB180 computer with the XBIOS
enhanced operating system.  Before you say "But I don't have an SB180," let
me assure you that the techniques have more general applicability.  The
specific XBIOS problem is one that has come up often and has been the source
of considerable frustration to XBIOS users.  [They are in good company, by
the way.  Just as I was finishing this article, I got a call from Bridger
Mitchell about this very subject!]  I am only sorry that it took me so long
to get around to working on it.  Gene Pizzetta, a fellow Bostonian, was the
squeaky wheel that finally got my attention, and he has contributed a number
of his own ideas to the solution.


Announcements

     Before we get down to business, I have, as usual, a few announcements
to make.  First I would like to remind readers once again about Bill
Tishey's superb collection of help files for the hundreds of Z-System
programs now available.  Bill can now generate diskettes in many formats
besides Apple (using his son's Commodore 128), and he is willing to fill
your diskettes with the files for only $10.  My column in issue #36 gave the
following procedure to follow: (1) send enough formatted diskettes (plainly
labeled with the format) to hold at least 1000K bytes (up from 800K back
then); (2) use a reusable disk mailer or enclose a mailer suitable for
returning the diskettes to you; and (3) enclose a return address label,
return postage, and the $10 copying fee.  Bill's address is 8335 Dubbs
Drive, Severn, MD 21144.  If you prefer (or if you need 96-tpi, 8" SSSD, or
NorthStar hard-sector formats), you can send the diskettes to me as well.

     Second, I would like to make a special point of calling your attention
to the GEnie RoundTable discussions that take place every Wednesday at 10pm
Eastern time.  The first such session of each month is devoted to Z-System,
and I am the moderator, so this is your chance for a real-time dialogue with
me.  Go to page "685;2" on GEnie and enter "Room 2".

     There are several changes to report in the roster of Z-Nodes. 
Regrettably, Bob Paddock's node #38 in Franklin, PA, has gone off the air. 
To offset that loss, however, node #73 in the St. Louis, MO, area has come
back to life after being down for several years.  Sysop George Allen and co-sysop Walt Stumper would be happy to hear from you at 314-821-1078 (PC-Pursuit MOSLO/24).  The equipment is currently a Xerox 820-II with a 10 Meg
drive, but the sysops hope to expand soon to a 30+ Meg Ampro.

     On the Z-Node front, I am also sorry to report that Z-Node Central
(Lillipute) was downed by hardware failures on both computers!  They have
been off the air for a couple of months already as I write this, and sysop
Richard Jacobson has just faced the truth: that it will not be coming back. 
Ladera Z-Node (#2) in Los Angeles will take over as Z-Node Central.  Chicago
area callers looking for Z support should check out the Antelope Freeway
system run by ZDOS-coauthor Carson Wilson for CFOG (Chicago area FOG).  This
is one of a small number of remote access systems running under the Z3PLUS
flavor of Z-System.  The phone number is 312-764-5152 (PC-Pursuit ILCHI/24). 
We expect that its 'System One' will soon be a Z-Node ('System Two' supports
MS-DOS).

     Finally, there have been some very significant developments with BDS C. 
Leor Zolman completed some major additions to the Z version (BDS Z), and the
final release has just gone out as I write this column in mid October. 
Programs generated by BDS Z now have a full Z-System header and can be
linked as type-3 programs to load and run at an arbitrary address.  ZDOS
coauthor Cam Cotrill has already released a substantial amount of BDS Z code
for performing the functions in the SYSLIB, VLIB, and Z3LIB assembly-language libraries that are not already built into BDS Z.

     Leor has now turned over all of the marketing and some of the
development responsibility for BDS C to me.  Recognizing that the $90 price
tag of the full package, however reasonable for what one gets, is an
impediment to new users who want to experiment with C, we have prepared a
low cost introductory package that (1) includes only one version of the code
(either standard CP/M or Z-System), (2) contains only the essential files,
and (3) comes with an abridged version of the manual (and without the fancy
BD Software binder).  This package will be offered for only $60.  Other
parts of the full package can be added later: $25 for the second version of
the compiler, $25 for the support materials (RED editor, CDB debugger, and
the parts of the manual covering them), or $40 for both at once.  If the
whole package is ordered at once, it comes complete with an attractive
binder (also available with the introductory package for $5 extra).

     It should be noted that BDS Z generates programs that run perfectly
well under standard CP/M.  Naturally, they will not recognize Z-System
features like named directories, but they will accept the now standard DU:
extended drive/user syntax instead of the older U/D: format of standard BDS
C.  The only disadvantage of using BDS Z rather than BDS C on a standard
CP/M system is that the programs carry Z-System overhead (about 800 bytes)
that don't provide them with any functionality.


               What is a Microcomputer Operating System For?

     The basic function of an operating system is to make one's life --
one's computing life, that is -- simpler.  When microcomputers first came
out, the biggest burden was dealing with the hardware.  It was no fun for
the computer user and programmer (largely synonymous in those days) to have
to deal over and over with the intricacies of the physical operation of the
hardware, such as getting characters to and from the terminal or paper tape
reader/punch, not to mention the dauntingly more complex task of managing
data on a magnetic tape or floppy diskette drive.

     Gary Kildall's CP/M operating system provided a solution -- and a very
good one (by and large) in my opinion -- to those problems.  It did so by
implementing a standardized and modular interface that handled the basic
device communication tasks.  CP/M, which stood (I believe) for "Control
Program for Microcomputers," was the master program that one got running on
the computer right after power up.  It would then allow one to load and run
other programs, with control always returning to the CP/M master program
after each user program finished.

     Besides accepting and interpreting commands issued by the computer
operator, an operating system like CP/M also provides resident code (always
ready in memory) for performing certain functions that application programs
will often want to use.  The simpler functions are things like sending a
character to the terminal screen; the more complex ones include fetching
from or writing to a floppy diskette the information associated with a
logical entity known as a file.

     With these functions implemented in the operating system code,
application programs are easier to write and do not have to include the same
code over and over.  More importantly, they can run on a variety of hardware
platforms, since the details of the physical hardware are handled by the
operating system code, and the program can deal with things at a logical
level.


Logical vs. Physical

     Perhaps this is a good time for a brief aside on this matter of logical
versus physical.  We use the adjective "physical" when we are talking about
things that are actually in the hardware.  In the case of a floppy disk, for
example, the physical items are the bits of data stored as magnetization
patterns.  These bits are grouped into sectors, and the sectors into tracks. 
In the case of a terminal screen, the physical items are the patterns of
illuminated dots that we recognize as letters, numbers, and other symbols.

     On the other hand, we use the adjective "logical" to describe those
things which are essentially the creation of our minds (and programs).  For
example, there is no such physical thing as a "file."  No matter how you
examine a diskette, you will never find a file on it (as such); you will
find only sectors and tracks.  It is our choice to organize the data on the
disk in a way that associates groups of such sectors with a file names and
to store the file names in a particular group of sectors on the disk.


Modularity

     CP/M is modular in the sense that it divides up the functions of the
operating system into separate packages.  One part is called the BIOS (basic
input/output system).  This part, which lives at the very top of the memory
address space, deals directly with the hardware.  It reads and writes
physical sectors from and to a diskette; it determines whether or not a key
has been pressed on the keyboard and, if so, which key; and it sends
characters to the screen.  The BIOS is the only part of CP/M that is
different for each hardware implementation of a CP/M computer.

     The second CP/M module is called the BDOS (basic disk operating
system).  It deals with logical constructs.  We have already spoken of
files.  When a file is referred to, the BDOS figures out which physical
tracks and sectors contain the data for that file.  Another logical
construct is lines of text.  The BDOS has a function to send a complete line
of text to the screen (as opposed to the BIOS, which can send only a single
character), and it has another function to get a complete line of text from
the user, allowing a limited amount of editing.  These functions make it
much easier for the application programmer to write his or her program.

     The last CP/M module is called the CCP (console command processor).  It
gets a command typed by the user at the console and takes the appropriate
action to carry out that command.  Some commands, such as DIR or ERA, are
implemented directly in the CCP code.  Others require that a COM file be
loaded from diskette and executed.


Command Processing Under CP/M

     For the most part, CP/M accomplishes the functions it was designed to
perform in admirable fashion.  However, it was so concerned with solving the
hardware interface problem (the programmer interface) that it devoted
relatively little attention to the user interface.  To be fair, it was born
in the days when 16K of memory cost about $500 (in 1970s dollars, no less)
and occupied an entire S-100 card (bigger by far than a whole SB180FX
computer with 512K).  Today we might not think that 64K is very much (some
say that OS/2 feels dreadfully cramped in less than 3 Megs!), but it makes a
lot of things possible that 48K (or even less) would not allow.

     CP/M's command processor did little more than the minimum it was
required to do, namely to run a few resident commands and to load external
commands from disk.  It did not provide many services to make the operator's
life easier.  You had to specify rather exactly the command you wanted
performed; no leeway was allowed.  And if you made a mistake, CP/M did not
try to help; it just shrugged its shoulders and emitted a question mark.


The Niceties of Z-System

     The Z-System has evolved over a period of nearly a decade now, but its
goal from the very beginning has always been to make it easier and more
convenient to operate the computer.  My ideal is to have the computer do
everything that it possibly can do for the user and leave to the user only
those tasks that no computer could possibly figure out on its own.  The
command processor improvements I have introduced and the utilities I have
written have all been directed toward that goal.  I will now run through a
short summary of Z-System features and try to indicate how they make the
operator's life easier.  This list is adapted from my book, "The ZCPR33
User's Guide."


User Area Access

     CP/M introduced the concept of disk "user" areas, which allowed the
operating system to group files into separate logical directories
(physically the files are all stored in the same directory, but they are
tagged to indicate the user area).  Unfortunately, CP/M provided no
practical way to access files across user areas, which made them almost
useless.

     Back in the days when disks held only about 100K, there wasn't much
need for this kind of organization, but today floppy diskettes commonly have
a capacity between 350K and 1.3 Meg.  Hard disks with many tens of megabytes
are also inexpensive and common.  Under these circumstances, a single
logical drive can hold hundreds or even thousands of files, and some way to
organize them becomes essential.

     Z-System makes it very easy and convenient to organize your files based
on user numbers.  Where CP/M allowed only a drive prefix to a file name
(D:NAME.TYP), Z-System allows drive and/or user number prefixes
(DU:NAME.TYP) so that files in other user areas as well as other drives can
be referenced directly.  In addition, Z-System allows meaningful names
(similar to DOS subdirectory names) to be assigned to drive/user areas. 
This provides an interface that is far more suitable to the way people think
and remember.  With the DU: form, the operator has to think about the
hardware (something he or she should not have to do, remember?); with named
directories, the operator thinks in terms of function (TEXT: for text files,
BDSC: for the C compiler, DBASE: for database files, and so on).


Terminal Independence and the Environment

     While some would argue that the DOS hardware and software standards
established by IBM's market dominance have resulted in an enforced
mediocrity, there is no doubt that having a single environment in which to
operate makes life much easier for applications programmers.  Programs for
DOS generally work right out of the box on any IBM compatible computer. 
Configuration is required only for fine-tuning.

     CP/M, on the other hand, was designed to allow programs to run on an
extremely wide variety of hardware.  In those days, "personal" computer took
on a different meaning -- each person designed and built his own hardware. 
CP/M could be made to work with all of them, but elaborate configuration
procedures were generally required, especially to match programs to the
particular terminal used.  To this day, we still have to deal with this
hardware diversity.

     What CP/M could have but failed to provide was a means for conveying to
application programs information about the operating environment.  Z-System
has several modules that afford such communication.  An area called the
environment descriptor (ENV) contains information about the system
configuration.  Another system area called the message buffer (MSG) stores
information that one program can leave for another program that runs later
to read.

     Part of the ENV is a section called the TCAP or Terminal-CAPability
descriptor.  The TCAP allows a program running under Z-System to determine
the type of terminal in use and to adapt to the control codes it uses for
special video operations.  The ENV has information about the size of the
screen and the printer's page.  It also contains such information as the CPU
clock speed and which disk drives are available (why allow attempts to log
into drive C: if there is no drive C: -- it often just hangs the computer). 
The Z-System supports many optional operating system features contained in
optional modules, and the ENV contains information about these modules also.

     The ENV and TCAP not only relieve the user of the nuisance of
installing programs; they also make it very easy to change the installation. 
Suppose, for example, you want to print some files in 132-column mode
instead of the usual 80-column mode.  Under CP/M you might very likely have
to get out a configuration program to redefine the printer setup.  With a Z
System print utility, you would simply change the mode on your printer, run
CPSET (console/printer set) to select the 132-column printer definition, and
run the same print program as before.


Command Processing Enhancements

     Under CP/M, you have to specify where the COM file to be run is located
(otherwise the current drive is assumed).  This is a perfect example of
something that a computer can easily be smart enough to do for you, and Z
System does.  As with modern versions of DOS (which took many years to catch
on to this Z-System feature), you specify a list of directory areas that the
operating system will scan for a requested COM file.  If you wish (as you
might when you know that your COM file is not on the search path), you can
specify a directory using either the DU: prefix or the named directory DIR:
prefix, and you are thus not limited to the current user area or the path.

     With Z-System one is also no longer limited to issuing commands one at
a time (DOS has been even slower to catch on to this).  A single line of
command input can contain a whole sequence of commands.  As a result, you do
not have to interrupt your thinking to wait for one command to finish before
you can specify the second and subsequent steps in a process.  You can work
out a strategy for what you want to accomplish and issue all the commands at
once, before you forget or get confused.

     Many oft-repeated computational tasks involve sequences of commands
(e.g., editing, assembling, linking, running; or editing, spell checking,
printing).  In such cases, the Z-System alias facility (similar in some ways
to SUBMIT but far more flexible) can be used to define a new command name,
which, when invoked, performs the entire sequence.  This saves the user a
lot of typing but more importantly eliminates the need to remember exactly
what the sequence is.  Basically, you solve the problem once and put the
solution into an alias script.  From then on, the computer is smart enough
to take care of the complex details for you.  I have given many examples of
this in past columns.


Conditional Command Execution

     There is only so much one can accomplish on a computer (or in life)
without making decisions.  Have you ever seen a programming language with no
ability to perform tests and act in different ways depending on the results? 
Flow control (IF/ELSE/ENDIF) is unique to the Z-System command processor. 
Other operating systems that offer flow control at all limit it to operation
inside a batch or script language.

     A special set of Z-System commands can test a wide range of conditions,
and the command processor will use the results of the tests to decide which
subsequent commands will be performed and which will be skipped.  This
allows the Z-System to respond in a remarkably flexible and intelligent way. 
The solution to a complex computing task, one that requires on-the-spot
decision-making, can be worked out once and embedded in an alias command. 
Then you won't have to tax your brain the next time you need to perform this
task, and novice users will be able to do things on your computer that would
have been beyond their own ability to figure out.


Command Processor Shells

     If you do not want to deal with the operating system at the command
level or if you want to have a command processor with different features,
the Z-System shell facility allows you to install substitute user interfaces
of your own choice at will.  They can even be nested within each other.

     Shells come in two common varieties: menu shells and history shells. 
The menu interfaces allow the user to pick tasks with single keystrokes and
have the shell program generate the complex sequences of commands required
to perform those tasks.  The menu system shields the user from complexity,
saves typing, and greatly reduces the chance of error.

     History shells are enhanced command processors that remember your
commands and allow you to recall and edit previous command lines.  I wish
the Apollo Domain minicomputer system I use at work (not to mention my DOS
computer) had a history shell one quarter as nice as Z-System's LSH or EASE. 
They work like powerful wordprocessors on your command history, allowing
searching and extensive editing.


What If You Make a Mistake

     This is one of the other areas in which most operating systems behave
in an abominably primitive manner.  When you issue a command that cannot be
performed, they just issue an error message and then dump you back to square
one.  Often you are not even told what sort of error occurred (consider
DOS's wonderfully helpful "bad command" message).

     The Z-System behaves in a civilized manner under these circumstances. 
When an error occurs, the command processor turns the bad command line over
to a user-specified error handler.  The most sophisticated error handlers
allow the operator to edit the command and thus recover easily from typing
mistakes.  In a multiple command sequence, if subsequent commands were
allowed to run after an earlier command failed, there could be disastrous
repercussions, and an error handler is indispensible.

     The system environment even contains an error type, which the error
handler can use to give you more specific information about what went wrong. 
It may be the familiar error of a COM file that could not be found, but
there are many other possible causes for the difficulty.  A file that you
specified as an argument might not have been found (e.g., "TYPE FILENAM"
when you meant "TYPE FILENAME"), or you may have specified an ambiguous file
name to a program that cannot accept one (e.g., "TYPE *.DOC").


System Security

     Like minicomputer and mainframe operating systems, the Z-System is a
secure operating system.  This means that it has mechanisms for limiting
what any particular user can do or get access to.  Dangerous commands (such
as erasing, copying, or renaming files) can be disabled when ordinary users
are operating the system but enabled when a privileged user is at work. 
Areas of your disk can be restricted from access for storage of confidential
or other sensitive information.  These security features come in very handy
in the implementation of a remote access system or bulletin board (see Lee
McEwen's article in this issue).  There is no need for additional security
to be provided by the remote interface program (BYE).  The Z-System already
includes a full suite of programs for regulating and controlling system
security.


Summary

     To sum it up, the goal of the Z-System is to provide an operating
system that can be tailored extensively to user preferences and that can be
made to handle on its own and automatically as many computational details as
it can, leaving the user free to concentrate solely on those aspects of
computer operation that require human intelligence.

                           Faking Out The System

     For the technical part of this column, I would like to talk briefly
about some techniques for adding extensions to a Z-System that it was not
designed to accept.  The need for this trick arose in connection with the
installation of ZSDOS and ZDDOS (and their clock drivers) on an SB180
computer with the XBIOS enhanced BIOS, but it can be useful in other
situations as well.

     XBIOS is a very nice and flexible system.  One of its main features is
that it keeps much of the BIOS in an alternate memory bank, leaving a much
larger TPA (transient program area) for application programs than did the
standard BIOS from MicroMint.  The configuration and loading process,
however, is somewhat unconventional (a forerunner in some ways to the NZCOM
and Z3PLUS techniques).

     The XBIOS system is loaded not from system tracks on the disk but from
a file.  This file is generated by a special utility program called SYSBLD
(SYStem BuiLD) that allows one to define in a rather flexible way the
configuration of one's personal Z-System, including the names of the CCP and
DOS files to be used.  Those component files, however, must be available in
REL format, and the new Z-System DOS components are supplied in ZRL format
only (because they have hooks to other parts of the system that can be
resolved only by that format).


Changing Systems Using JetLDR

     JetLDR is a lovely little utility written by Bridger Mitchell that
knows how to load almost any module in a Z operating system.  It is much
faster and more careful than its predecessors, LDR and LLDR, and it is not
limited to the non-code Z modules -- such as the NDR (named directory
register) -- or to code modules preassembled for a fixed system -- such as
an RCP (resident command package) module FIXED.RCP.  It can load code
modules assembled in ZRL format to whatever address that module occupies in
the current system and with all the hooks to other Z-System modules
generated at load time.  Thus MYRCP.ZRL, assembled once, can be used in any
system configuration that allocates enough room for an RCP of that size.

     Most remarkably, JetLDR can load even main operating system modules:
CCP, DOS, or BIOS.  Special adjunct configuration files (CFG) are used to
help it in some of these specialized tasks (a little more about that later). 
JetLDR's internal help screen is reproduced in Fig. 1 so you can see the
whole list of modules it can handle.  It is available from the usual Z
suppliers for $20.

     So, the obvious solution to the problem of getting ZSDOS or ZDDOS
running under XBIOS is first to generate and boot a standard ZRDOS system
(ZRDOS.REL comes with the SB180) and then to replace ZRDOS with, say, ZDDOS
using the JetLDR command:

	JETLDR ZDDOS.ZRL

ZSDOS can be loaded just as easily.  On my system I have ARUNZ aliases that
swap DOSs in a jiffy this way in case I want to perform some experiments.


There's The Rub

     Now comes the problem.  It's very nice that we now have ZDDOS or ZSDOS
loaded and running, but if we want to take advantage of its wonderful time
and date features, we must find a way to load its clock and (for ZSDOS)
stamping module, too.  The ZDOS utility SETUPZST makes it very easy to
create the required loader, LDTIM.COM; the problem is: where can LDTIM put
the driver code?  [Aside: For those who own it, I am told that the
DateStamper BSX module will work with ZSDOS, but I have not tried this
myself.  It requires no memory to load.]

     In an NZCOM system, the MKZCM system definition utility allows one to
specify a "user buffer" area in memory, and this is just perfect for the
clock/stamp module.  ZDOS even has special facilities for taking advantage
of this buffer.  LDTIM can automatically determine the location of that
buffer and install the drivers there, and a special patch to NZCOM (included
with the ZDOS package) gives NZCOM the ability to reconnect the drivers
automatically after a new DOS is loaded.

     XBIOS's SYSBLD utility, unfortunately, does not support such a user
buffer (this is true even in the 1.2 version that is able to load ZRL
files).  There is a way to trick the system into making some room for extra
memory modules.  This is to assign the extra memory space needed to one of
the standard modules, such as the RCP.  For example, if you use an RCP of
the usual 2K (16 record) size and need one page (two records) of memory for
a ZDDOS clock driver, you simply specify an 18-record RCP space.  Then, when
SETUPZST asks you for the address to which the clock driver should be
loaded, you give it the starting address of the last page of this RCP space.

     Once these steps have been followed, ZDDOS should be running with date
stamping.  ZSDOS could be installed similarly except that even more extra
space would have to be allocated to the RCP.  Although what I have described
so far will get the system running, there is some danger that an oversize
RCP could be loaded by accident and overwrite the clock driver.  To prevent
this, the ENV module should be patched to indicate that only the actual 16
records (10H) are available.

     For those who do not face the problem of installing ZDOS on an XBIOS
equipped SB180, there are other uses of this kind of trick.  For people who
do not have the necessary tools (e.g., MOVCPM) to move the BIOS down to make
room for special drivers (such as RAM disk drivers and special I/O boards),
this same trick can be applied to open up protected-memory space for them. 
Other people may find it useful for quick experiments with special drivers
before going to the trouble of moving the operating system around.

     There is one final refinement I would like to mention.  It is something
I learned from Gene Pizzetta, who took my general recommendations above and
worked out the details (see his file, ZD-XB11.LBR, available on many Z
Nodes).  I have usually used either the IOP or RCP modules for this trick,
but Gene recommended using the NDR instead.  The reason for this is that the
IOP, RCP, and FCP get allocated in 128-byte chunks, while the NDR gets
allocated in much smaller 18-byte chunks, the space required for one name. 
If your clock driver takes, for example, 270 bytes (10EH), you would have to
allocate three extra records, because the driver is a tiny bit over two
records.  If you steal space from an NDR, you can add just two records, but
reduce the number of names in the NDR by 1.


Changing Command Processors

     Generating a new CCP using JetLDR is a little trickier than changing
the DOS.  JetLDR could, as it does with a DOS or BIOS module, load the new
CCP into its operating position in memory, but this would be of questionable
value, since the CCP would survive only until the next warmboot.  So,
instead, when processing a CCP ZRL module, JetLDR normally writes the
resulting absolute-code CCP to a file ZCCP.CCP (in the root directory, I
believe).

     This is where CFG files come into play.  They are special code modules
that JetLDR uses to perform special processing (see the file JLTOOLS.LBR on
Z-Nodes for more detailed information).  For example, CCPCFG.ZRL is one that
tells JetLDR how to deposit the absolute CCP code that it generates directly
into the XBIOS ram image of the CCP in banked memory (from which it is
loaded on each warm boot).  A similar CFG file could be written to tell
JetLDR how to install the new CCP onto the system tracks of the current
drive-A disk, but so far no one has done this.  I would be happy to provide
the CCPCFG module to XBIOS owners who would like it or to others who would
like to use it as a model for writing other CFG files (send me a formatted
disk with your copy of JetLDR, return mailer, etc.).

-----------------------------------------------------------------------------

JetLDR for Z-Systems (ZCPR3), Version 1.00
Copyright (c) 1988 Bridger Mitchell

Syntax:
   JetLDR  [du:][library][.lbr]  member1.typ  member2.typ  ...
  or
   JetLDR  [du:]file1.typ  [du:]file2.typ  [du:]file3.typ ...

  ENV - environment                FCP - flow commands
  IOP - input/output               RCP - resident commands
  NDR - named directories          Z3T - terminal capabilities
  ZRL or REL - module in SLR or MS-relocatable (REL) format
      with member name: RCP, FCP, IOP, CCP, CP3, DOS, DO3, BIO, CFG or BSX

Notes:
  If first file is a library, extract remaining files from it.
  An ENV file must be the first loaded.
  Preceed special modules (DOS, RSX, BSX, ...) with appropriate CFG file.

Use Path: YES   Root Only: NO   Scan Current: YES   Explicit Directory: A0:

                         -------------------------

Figure 1.  This is the internal help screen displayed by the command
"JETLDR //".  It shows how flexible a package loader JetLDR is.

-----------------------------------------------------------------------------

                             